/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.cull.graph;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import me.jellysquid.mods.sodium.client.render.chunk.cull.ChunkCuller;
import me.jellysquid.mods.sodium.client.render.chunk.cull.graph.ChunkGraphIterationQueue;
import me.jellysquid.mods.sodium.client.render.chunk.cull.graph.ChunkGraphNode;
import me.jellysquid.mods.sodium.client.util.math.ChunkSectionPos;
import me.jellysquid.mods.sodium.client.util.math.FrustumExtended;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.chunk.SetVisibility;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ChunkGraphCuller
implements ChunkCuller {
    private final Long2ObjectMap<ChunkGraphNode> nodes = new Long2ObjectOpenHashMap();
    private final ChunkGraphIterationQueue visible = new ChunkGraphIterationQueue();
    private final World world;
    private final int renderDistance;
    private FrustumExtended frustum;
    private boolean useOcclusionCulling;
    private int activeFrame = 0;
    private int centerChunkX;
    private int centerChunkY;
    private int centerChunkZ;

    public ChunkGraphCuller(World world, int renderDistance) {
        this.world = world;
        this.renderDistance = renderDistance;
    }

    @Override
    public IntArrayList computeVisible(Vec3d cameraPos, FrustumExtended frustum, int frame, boolean spectator) {
        this.initSearch(cameraPos, frustum, frame, spectator);
        ChunkGraphIterationQueue queue = this.visible;
        for (int i = 0; i < queue.size(); ++i) {
            ChunkGraphNode node = queue.getNode(i);
            short cullData = node.computeQueuePop();
            for (EnumFacing dir : DirectionUtil.ALL_DIRECTIONS) {
                ChunkGraphNode adj;
                if (this.useOcclusionCulling && (cullData & 1 << dir.ordinal()) == 0 || (adj = node.getConnectedNode(dir)) == null || !this.isWithinRenderDistance(adj)) continue;
                this.bfsEnqueue(node, adj, dir.func_176734_d(), cullData);
            }
        }
        return this.visible.getOrderedIdList();
    }

    private boolean isWithinRenderDistance(ChunkGraphNode adj) {
        int x = Math.abs(adj.getChunkX() - this.centerChunkX);
        int z = Math.abs(adj.getChunkZ() - this.centerChunkZ);
        return x <= this.renderDistance && z <= this.renderDistance;
    }

    private void initSearch(Vec3d cameraPos, FrustumExtended frustum, int frame, boolean spectator) {
        this.activeFrame = frame;
        this.frustum = frustum;
        this.useOcclusionCulling = Minecraft.func_71410_x().field_175612_E;
        this.visible.clear();
        BlockPos origin = new BlockPos(cameraPos.field_72450_a, cameraPos.field_72448_b, cameraPos.field_72449_c);
        int chunkX = origin.func_177958_n() >> 4;
        int chunkY = origin.func_177956_o() >> 4;
        int chunkZ = origin.func_177952_p() >> 4;
        this.centerChunkX = chunkX;
        this.centerChunkY = chunkY;
        this.centerChunkZ = chunkZ;
        ChunkGraphNode rootNode = this.getNode(chunkX, chunkY, chunkZ);
        if (rootNode != null) {
            rootNode.resetCullingState();
            rootNode.setLastVisibleFrame(frame);
            if (spectator && this.world.func_180495_p(origin).func_185914_p()) {
                this.useOcclusionCulling = false;
            }
            this.visible.add(rootNode);
        } else {
            chunkY = MathHelper.func_76125_a((int)(origin.func_177956_o() >> 4), (int)0, (int)15);
            ArrayList<ChunkGraphNode> bestNodes = new ArrayList<ChunkGraphNode>();
            for (int x2 = -this.renderDistance; x2 <= this.renderDistance; ++x2) {
                for (int z2 = -this.renderDistance; z2 <= this.renderDistance; ++z2) {
                    ChunkGraphNode node2 = this.getNode(chunkX + x2, chunkY, chunkZ + z2);
                    if (node2 == null || node2.isCulledByFrustum(frustum)) continue;
                    node2.resetCullingState();
                    node2.setLastVisibleFrame(frame);
                    bestNodes.add(node2);
                }
            }
            bestNodes.sort(Comparator.comparingDouble(node -> node.getSquaredDistance(origin)));
            for (ChunkGraphNode node3 : bestNodes) {
                this.visible.add(node3);
            }
        }
    }

    private void bfsEnqueue(ChunkGraphNode parent, ChunkGraphNode node, EnumFacing flow, short parentalData) {
        if (node.getLastVisibleFrame() == this.activeFrame) {
            node.updateCullingState(flow, parentalData);
            return;
        }
        node.setLastVisibleFrame(this.activeFrame);
        if (node.isCulledByFrustum(this.frustum)) {
            return;
        }
        node.setCullingState(parentalData);
        node.updateCullingState(flow, parentalData);
        this.visible.add(node);
    }

    private void connectNeighborNodes(ChunkGraphNode node) {
        for (EnumFacing dir : DirectionUtil.ALL_DIRECTIONS) {
            ChunkGraphNode adj = this.findAdjacentNode(node, dir);
            if (adj != null) {
                adj.setAdjacentNode(dir.func_176734_d(), node);
            }
            node.setAdjacentNode(dir, adj);
        }
    }

    private void disconnectNeighborNodes(ChunkGraphNode node) {
        for (EnumFacing dir : DirectionUtil.ALL_DIRECTIONS) {
            ChunkGraphNode adj = node.getConnectedNode(dir);
            if (adj != null) {
                adj.setAdjacentNode(dir.func_176734_d(), null);
            }
            node.setAdjacentNode(dir, null);
        }
    }

    private ChunkGraphNode findAdjacentNode(ChunkGraphNode node, EnumFacing dir) {
        return this.getNode(node.getChunkX() + dir.func_82601_c(), node.getChunkY() + dir.func_96559_d(), node.getChunkZ() + dir.func_82599_e());
    }

    private ChunkGraphNode getNode(int x, int y, int z) {
        return (ChunkGraphNode)this.nodes.get(ChunkSectionPos.asLong(x, y, z));
    }

    @Override
    public void onSectionStateChanged(int x, int y, int z, SetVisibility occlusionData) {
        ChunkGraphNode node = this.getNode(x, y, z);
        if (node != null) {
            node.setOcclusionData(occlusionData);
        }
    }

    @Override
    public void onSectionLoaded(int x, int y, int z, int id) {
        ChunkGraphNode node = new ChunkGraphNode(x, y, z, id);
        ChunkGraphNode prev = (ChunkGraphNode)this.nodes.put(ChunkSectionPos.asLong(x, y, z), (Object)node);
        if (prev != null) {
            this.disconnectNeighborNodes(prev);
        }
        this.connectNeighborNodes(node);
    }

    @Override
    public void onSectionUnloaded(int x, int y, int z) {
        ChunkGraphNode node = (ChunkGraphNode)this.nodes.remove(ChunkSectionPos.asLong(x, y, z));
        if (node != null) {
            this.disconnectNeighborNodes(node);
        }
    }

    @Override
    public boolean isSectionVisible(int x, int y, int z) {
        ChunkGraphNode render = this.getNode(x, y, z);
        if (render == null) {
            return false;
        }
        return render.getLastVisibleFrame() == this.activeFrame;
    }
}

